/**
 * \file: exchnd_collector_arm.c
 *
 * Architecture specific collector implementation
 * Some data collected in the exception handler is collected in the user
 * space. The file handle ptrace related arch generic gathering.
 *
 * \component: Exception handler
 *
 * \author: Frederic Berat <fberat@de.adit-jv.com>
 *
 * \copyright (c) 2010, 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 ***********************************************************************/
#ifdef __arm__

#include <ctype.h>
#include <dlfcn.h>
#include <signal.h>
#include <libunwind.h>
#include <libunwind-ptrace.h>
#include <limits.h>

#include <sys/ioctl.h>
#include <sys/ptrace.h>

#include <linux/exchnd.h>

#include "exchnd_collector.h"

int (*unw_getcontext_p)(unw_context_t *);

static const char libname[] = "libunwind-arm.so.8";

const char *libunwind_arch_lib()
{
    return libname;
}

/*PRQA: Lint Message 160: External lib.*/
/*PRQA: Lint Message 529: External lib.*/
/*PRQA: Lint Message 505: External lib.*/
/*lint -save -e160 -e529 -e505*/
__attribute__ ((noinline)) static int unw_getcontext_f(unw_context_t *uc)
{
    return unw_getcontext(uc);
}
/*lint -restore*/

int libunwind_load_arch(void *lib)
{
    (void)lib;

    unw_getcontext_p = unw_getcontext_f;

    return 1;
}

void libunwind_unload_arch()
{
    return;
}

unsigned int get_arch_first_reg()
{
    return UNW_ARM_R0;
}

unsigned int get_arch_last_reg()
{
    return UNW_ARM_R15;
}

unsigned int get_arch_pc_reg()
{
    return UNW_ARM_R15;
}

unsigned int get_arch_lr_reg()
{
    return UNW_ARM_R14;
}

unsigned int get_arch_sp_reg()
{
    return UNW_ARM_R13;
}

unsigned int get_arch_fp_reg()
{
    return UNW_ARM_R11;
}
#endif /* __arm__ */